/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.rss;

import java.util.Date;

public class BaseRSSItem {
    private Integer idFluxRSS;
    private String nomFluxRSS = "";
    private Date pubDate;
    private Date pubTime;
    private String title = "";
    private String description = "";
    private String link = "";

    public String getNomFluxRSS() {
        return nomFluxRSS;
    }

    public void setNomFluxRSS(String nomFluxRSS) {
        this.nomFluxRSS = nomFluxRSS;
    }

    public void RSS_item(){
    }

    public void setIdFluxRSS(Integer i){
        idFluxRSS=i;
    }
    public void setPubDate(Date d){
        pubDate=d;
    }
    public void setTitle(String s){
        title=s;
    }
    public void setDescription(String s){
        description=s;
    }
    public void setLink(String s){
        link=s;
    }

    public Date getPubTime() {
        return pubTime;
    }

    public void setPubTime(Date pubTime) {
        this.pubTime = pubTime;
    }

    public Integer getIdFluxRSS(){
        return idFluxRSS;
    }
    public Date getPubDate(){
        return pubDate;
    }
    public String getTitle(){
        return title;
    }
    public String getDescription(){
        return description;
    }
    public String getLink(){
        return link;
    }

    @Override
    public boolean equals(Object obj) {
        if(obj == null){
            return false;
        }
        try{
            BaseRSSItem i = (BaseRSSItem)obj;
            boolean b = true;
            if(getIdFluxRSS() != null && idFluxRSS != null){
                b = b && i.getIdFluxRSS()==idFluxRSS;
            } else if(getIdFluxRSS() == null && idFluxRSS != null ||
                    getIdFluxRSS() != null && idFluxRSS == null){
                return false;
            }
            if(getTitle() != null && title != null){
                b = b && i.getTitle().equals(title);
            } else if(getTitle() == null && title != null ||
                    getTitle() != null && title == null){
                return false;
            }
            if(getLink() != null && link != null){
                b = b && i.getLink().equals(link);
            } else if(getLink() == null && link != null ||
                    getLink() != null && link == null){
                return false;
            }
            if(getPubDate() != null && pubDate != null){
                b = b && i.getPubDate().equals(pubDate);
            } else if(getPubDate() == null && pubDate != null ||
                    getPubDate() != null && pubDate == null){
                return false;
            }
            return b;
        } catch(ClassCastException cce){
            return false;
        }
    }

    @Override
    public int hashCode() {
        int x = 0;
        if(getIdFluxRSS() != null){
            x += getIdFluxRSS().hashCode();
        }
        if(getTitle() != null){
            x += getTitle().hashCode();
        }
        if(getLink() != null){
            x += getLink().hashCode();
        }
        if(getPubDate() != null){
            x += getPubDate().hashCode();
        }
        return x;
    }

    public String toString(){
        return "["+String.format("%td/%tm/%tY", pubDate, pubDate, pubDate)+
                " | "+nomFluxRSS+"] "+title;
    }
}
